package com.armannubtk.blood_donation;

import android.app.AlertDialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.textfield.TextInputEditText;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

//======================================================================================================
public class AddData_Activity extends AppCompatActivity {

    TextInputEditText ed_name, edBloodGroup, ed_zillaName, ed_mobile;
    ProgressBar progressBar;
    MaterialButton btnSubmit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.add_data_activity);

        ed_name = findViewById(R.id.ed_name);
        edBloodGroup = findViewById(R.id.edBloodGroup);
        ed_zillaName = findViewById(R.id.ed_zillaName);
        ed_mobile = findViewById(R.id.ed_mobile);
        progressBar = findViewById(R.id.progressBar);
        btnSubmit = findViewById(R.id.btnSubmit);

        btnSubmit.setOnClickListener(v -> {

            String name = ed_name.getText().toString().trim();
            String bloodGroup = edBloodGroup.getText().toString().trim();
            String mobile = ed_mobile.getText().toString().trim();
            String zilla = ed_zillaName.getText().toString().trim();

            if (name.isEmpty()) {
                ed_name.setError("👤 আপনার নাম লিখুন");
                return;
            }
            if (bloodGroup.isEmpty()) {
                edBloodGroup.setError("🩸 রক্তের গ্রুপ লিখুন");
                return;
            }
            if (zilla.isEmpty()) {
                ed_zillaName.setError("📝 জেলার নাম লিখুন");
                return;
            }
            if (mobile.isEmpty() || mobile.length() < 11) {
                ed_mobile.setError("📞 সঠিক মোবাইল নাম্বার দিন");
                return;
            }

            AddData(name, bloodGroup, mobile, zilla);
        });
    }

    //=====================================================
    private void AddData(String name, String bloodGroup, String mobile, String zilla) {

        progressBar.setVisibility(View.VISIBLE);

        String url = "https://khulnagtech.fun/client_project/RoktoBondhon/data_insert.php";

        StringRequest stringRequest = new StringRequest(
                Request.Method.POST,
                url,
                response -> {

                    progressBar.setVisibility(View.GONE);

                    try {
                        JSONObject jsonObject = new JSONObject(response);

                        if (jsonObject.getString("status").equals("success")) {

                            String id = jsonObject.getString("id");
                            String mobileDB = jsonObject.getString("mobile");

                            SharedPreferences sp = getSharedPreferences("myApp", MODE_PRIVATE);
                            SharedPreferences.Editor editor = sp.edit();
                            editor.putString("user_id", id);
                            editor.putString("mobile", mobileDB);
                            editor.apply();

                            new AlertDialog.Builder(AddData_Activity.this)
                                    .setTitle("👤 Success")
                                    .setMessage("Profile Created Successfully")
                                    .setCancelable(false)
                                    .setPositiveButton("OK", (d, w) -> {
                                        startActivity(new Intent(this, MainActivity.class));
                                        finish();
                                    })
                                    .show();
                        }

                    } catch (JSONException e) {
                        e.printStackTrace();
                        Toast.makeText(this, "JSON Error", Toast.LENGTH_SHORT).show();
                    }
                },
                error -> {
                    progressBar.setVisibility(View.GONE);
                    Toast.makeText(this, "Network Error", Toast.LENGTH_SHORT).show();
                }
        ) {
            @Override
            protected Map<String, String> getParams() throws AuthFailureError {

                Map<String, String> map = new HashMap<>();
                map.put("name", name);
                map.put("blood_group", bloodGroup);
                map.put("mobile", mobile);
                map.put("zilla", zilla);
                return map;
            }
        };

        RequestQueue queue = Volley.newRequestQueue(this);
        queue.add(stringRequest);
    }
}
