package com.armannubtk.blood_donation;

import android.app.AlertDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.airbnb.lottie.LottieAnimationView;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.Volley;
import com.google.android.material.button.MaterialButton;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

public class All_Fragment extends Fragment {
    //==================================================================================================
    ProgressBar progressbar;
    RecyclerView recyclearView;

    HashMap<String, String> hashMap = new HashMap<>();
    ArrayList<HashMap<String, String>> arrayList = new ArrayList<>();

    private MyAdapter myAdapter;
    boolean isLoaded = false;

    //==================================================================================================
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View myView = inflater.inflate(R.layout.all_fragment, container, false);
        //==================================================================================================
        recyclearView = myView.findViewById(R.id.recyclearView);
        progressbar = myView.findViewById(R.id.progressbar);


        //==================================================================================================
        return myView;
    }   // onCreateView end here
    //======================================================================================================

    // Create a Adapter
    private class MyAdapter extends RecyclerView.Adapter {

        private class MyViewHolder extends RecyclerView.ViewHolder {
            //---------------------------------------------------
            TextView tvName, tvZilla, tvBloodGroup;
            MaterialButton tvDate, btnAvailable;
            LottieAnimationView animationView_Call;

            //---------------------------------------------------
            public MyViewHolder(@NonNull View itemView) {
                super(itemView);
                //---------------------------------------------------
                tvName = itemView.findViewById(R.id.tvName);
                tvZilla = itemView.findViewById(R.id.tvZilla);
                tvBloodGroup = itemView.findViewById(R.id.tvBloodGroup);
                tvDate = itemView.findViewById(R.id.tvDate);
                btnAvailable = itemView.findViewById(R.id.btnAvailable);
                animationView_Call = itemView.findViewById(R.id.animationView_Call);

                //---------------------------------------------------
            }
        }  //  MyViewHolder end here

        //*********************************************************************************************************
        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            //------------------------------------------------------------------------------------
            LayoutInflater layoutInflater = getLayoutInflater();
            View myView = layoutInflater.inflate(R.layout.item, parent, false);
            //------------------------------------------------------------------------------------
            return new MyViewHolder(myView);
        }    //      onCreateViewHolder  end here =============


        //*********************************************************************************************************
        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            //------------------------------------------------------------------------------------
            MyViewHolder myViewHolder = (MyViewHolder) holder;

            hashMap = arrayList.get(position);
            String id = hashMap.get("id");
            String name = hashMap.get("name");
            String mobile = hashMap.get("mobile");
            String zilla = hashMap.get("zilla");
            String blood_group = hashMap.get("blood_group");
            String status = hashMap.get("status");
            String date_time = hashMap.get("date_time");


            // tvDisplay
            myViewHolder.tvName.setText(name);
            myViewHolder.tvZilla.setText(zilla);
            myViewHolder.btnAvailable.setText(status);
            myViewHolder.tvDate.setText(date_time);
            myViewHolder.tvBloodGroup.setText(blood_group);

            // Call button
            myViewHolder.animationView_Call.setOnClickListener(v -> {
                Intent intent = new Intent(Intent.ACTION_DIAL);
                intent.setData(Uri.parse("tel:" + mobile));
                startActivity(intent);
            });


            //------------------------------------------------------------------------------------
        }    //      onBindViewHolder  end here =============

        //*********************************************************************************************************
        @Override
        public int getItemCount() {
            return arrayList.size();
        }
    }  //  MyAdapter end here


    // All Data Get
    private void getAllData() {
        arrayList.clear();
        progressbar.setVisibility(View.VISIBLE);

        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("key", "key");
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
        jsonArray.put(jsonObject);

        String url = "https://khulnagtech.fun/client_project/RoktoBondhon/all_data_get.php";
        JsonArrayRequest jsonArrayRequest = new JsonArrayRequest(Request.Method.POST, url, jsonArray, new Response.Listener<JSONArray>() {
            @Override
            public void onResponse(JSONArray response) {
                //------------------------------------------
                progressbar.setVisibility(View.GONE);

                for (int x = 0; x < response.length(); x++) {

                    try {
                        //------------------------------------------
                        JSONObject jsonObject1 = response.getJSONObject(x);

                        String id = jsonObject1.optString("id", "");
                        String name = jsonObject1.optString("name", "");
                        String mobile = jsonObject1.optString("mobile", "");
                        String zilla = jsonObject1.optString("zilla", "");
                        String blood_group = jsonObject1.optString("blood_group", "");
                        String status = jsonObject1.optString("status", "");
                        String date_time = jsonObject1.optString("date_time", "");

                        hashMap = new HashMap<>();
                        hashMap.put("id", id);
                        hashMap.put("name", name);
                        hashMap.put("mobile", mobile);
                        hashMap.put("zilla", zilla);
                        hashMap.put("blood_group", blood_group);
                        hashMap.put("status", status);
                        hashMap.put("date_time", date_time);
                        arrayList.add(hashMap);

                        //------------------------------------------
                    } catch (JSONException e) {
                        //   throw new RuntimeException(e);
                        Toast.makeText(getActivity(), "App Crash All: "+e, Toast.LENGTH_SHORT).show();
                    }
                }  //  Loop end here

                // Adapter ke Call kora
                // Adapter ke Call kora
                myAdapter = new MyAdapter();
                recyclearView.setAdapter(myAdapter);
                recyclearView.setLayoutManager(new LinearLayoutManager(getActivity()));
                myAdapter.notifyDataSetChanged();
                //------------------------------------------
            }
        }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError volleyError) {
                //---------------------------------------------
                progressbar.setVisibility(View.GONE);
                new AlertDialog.Builder(getActivity())
                        .setMessage(String.valueOf(volleyError.getMessage()))
                        .create().show();

                //---------------------------------------------
            }
        });

        RequestQueue requestQueue = Volley.newRequestQueue(getActivity());
        requestQueue.add(jsonArrayRequest);

    }  //  getAllData  end here


    // Refres korar code
    @Override
    public void onResume() {
        super.onResume();
        //------------------------
        if (!isLoaded) {
            //--
            getAllData();
            isLoaded = true;
            //--
        }
        //------------------------
    }  // onResume end here


    //==================================================================================================
}  //  Fragment end here
//======================================================================================================