package com.armannubtk.blood_donation;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.FrameLayout;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import com.google.android.material.tabs.TabLayout;

import de.hdodenhof.circleimageview.CircleImageView;

public class MainActivity extends AppCompatActivity {
    //==================================================================================================
    TabLayout tabLayout;
    SharedPreferences sharedPreferences;
    //==================================================================================================
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });
        //==================================================================================================
        tabLayout = findViewById(R.id.tabLayout);






        //*************************************************************************************************************
        sharedPreferences = getSharedPreferences("myApp", MODE_PRIVATE);
        String mobile =  sharedPreferences.getString("mobile", "");

        if (mobile.length() <= 0){
            startActivity(new Intent(MainActivity.this, AddData_Activity.class));
            finish();
        } else {
            // home page a class ke call kora
            getSupportFragmentManager().beginTransaction().replace(R.id.frameLayout, new All_Fragment()).commit();
        }  // condition end here








        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {

                if (tab.getPosition() == 0){
                    //-----------------------------------
                    getSupportFragmentManager().beginTransaction().replace(R.id.frameLayout, new All_Fragment()).commit();
                    //-----------------------------------
                } else if (tab.getPosition() == 1) {
                    //-----------------------------------
                    getSupportFragmentManager().beginTransaction().replace(R.id.frameLayout, new Available_Fragment()).commit();
                    //-----------------------------------
                } else if (tab.getPosition() == 2) {
                    //-----------------------------------
                    getSupportFragmentManager().beginTransaction().replace(R.id.frameLayout, new NotAvailableFragment()).commit();
                    //-----------------------------------
                } else {
                    //-----------------------------------
                    getSupportFragmentManager().beginTransaction().replace(R.id.frameLayout, new Profile_Fragment()).commit();
                    //-----------------------------------
                }      // condition end here

            } //  onTabSelected  end here

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });










        //==================================================================================================
    }   //    onCreate Bundle  end here
    //======================================================================================================








    //==================================================================================================
}  //    public class MainActivity  end here
//======================================================================================================