package com.armannubtk.blood_donation;

import static android.content.Context.MODE_PRIVATE;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.google.android.material.button.MaterialButton;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class Profile_Fragment extends Fragment {
    //========================================================================================================================
    TextView tvName, tvZilla, tvBloodGroup;
    MaterialButton tvDate, btnAvailable;
    ProgressBar progressbar;

    boolean isLoaded = false;
    String currentStatus = "";
    String currentId = "";

    private static final String TAG = "Profile_Debug";
    //========================================================================================================================
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View myView = inflater.inflate(R.layout.profile_fragment, container, false);
        //========================================================================================================================

        tvName = myView.findViewById(R.id.tvName);
        tvZilla = myView.findViewById(R.id.tvZilla);
        tvBloodGroup = myView.findViewById(R.id.tvBloodGroup);
        tvDate = myView.findViewById(R.id.tvDate);
        btnAvailable = myView.findViewById(R.id.btnAvailable);
        progressbar = myView.findViewById(R.id.progressbar);



        //========================================================================================================================
        return myView;
    }
    //============================================================================================================================

    //  New Methode
    private void GetDataLoad()throws Exception{
        progressbar.setVisibility(View.VISIBLE);
        SharedPreferences sp = getActivity().getSharedPreferences("myApp", MODE_PRIVATE);
        String userId = sp.getString("user_id", "");

        if (userId.isEmpty()) {
            progressbar.setVisibility(View.GONE);
            Toast.makeText(getActivity(), "User ID not found. Please login again.", Toast.LENGTH_SHORT).show();
            return;
        }  // id condition end here

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", "profile");
            jsonObject.put("id", userId);

        String url = "https://khulnagtech.fun/client_project/RoktoBondhon/profile_info_get.php";
        JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(Request.Method.POST, url, jsonObject, new Response.Listener<JSONObject>() {
            @Override
            public void onResponse(JSONObject response) {
                //-------------------------------------------------------
                progressbar.setVisibility(View.GONE);
                Toast.makeText(getActivity(), "Received: "+response, Toast.LENGTH_SHORT).show();

                    currentId = response.optString("id", "");
                    String name = response.optString("name", "");
                    String zilla = response.optString("zilla", "");
                    String blood = response.optString("blood_group", "");
                    currentStatus = response.optString("status", "");
                    String date = response.optString("date_time", "");

                    tvName.setText(name);
                    tvZilla.setText(zilla);
                    tvBloodGroup.setText(blood);
                    tvDate.setText(date);
                    btnAvailable.setText(currentStatus);

                btnAvailable.setOnClickListener(v -> {
                    //========================================================

                    if (currentStatus.equals("Pending")){
                        new AlertDialog.Builder(getActivity())
                                .setTitle("\uD83E\uDE7A আপনি এই মুহূর্তে নিরপেক্ষ অবস্থানে আছেন")
                                .setMessage("❓ আপনি কি রক্ত দিতে চান?" +
                                        "\n\n\n")
                                .setPositiveButton("\uD83D\uDE46\u200D♂\uFE0F হ্যাঁ", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        //-----------------------------------
                                        dialog.dismiss();
                                        // Update Methode Call kora
                                        statusUpdate(currentId, currentStatus);
                                        //-----------------------------------
                                    }})
                                .setNegativeButton("\uD83D\uDE45\u200D♂\uFE0F না", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        dialog.dismiss();
                                    }}).create().show();
                        //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
                    } else if (currentStatus.equals("Available")) {
                        new AlertDialog.Builder(getActivity())
                                .setTitle("❓ আপনি কি কোনো ব্যক্তিকে রক্ত দিয়েছেন?")
                                .setMessage("যদি  \uD83E\uDE78  দিয়ে থাকেন, তাহলে কি আপনি এখন রক্ত দেওয়া আপাতত বন্ধ রাখতে চান?" +
                                        "\n\n\n")
                                .setPositiveButton("\uD83D\uDE46\u200D♂\uFE0F হ্যাঁ", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        //-----------------------------------
                                        dialog.dismiss();
                                        // Update Methode Call kora
                                        statusUpdate(currentId, currentStatus);
                                        //-----------------------------------
                                    }})
                                .setNegativeButton("\uD83D\uDE45\u200D♂\uFE0F না", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        dialog.dismiss();
                                    }}).create().show();
                        //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
                    }else if (currentStatus.equals("Not_Available")){
                        new AlertDialog.Builder(getActivity())  // shudhu matro ei AlertDialog ta show hoi. onno guli hosche na keno?
                                .setTitle("❓ আপনি কি রক্ত দিতে চান?")
                                .setMessage("\uD83E\uDE78 \uD83E\uDE78" +
                                        "\n\n\n")
                                .setPositiveButton("\uD83D\uDE46\u200D♂\uFE0F হ্যাঁ", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        //-----------------------------------
                                        dialog.dismiss();
                                        // Update Methode Call kora
                                        statusUpdate(currentId, currentStatus);
                                        //-----------------------------------
                                    }})
                                .setNegativeButton("\uD83D\uDE45\u200D♂\uFE0F না", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        dialog.dismiss();
                                    }}).create().show();
                        //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
                    }  //  condition end here
                    //========================================================
                });  //   btnAvailable  end here

                    //-------------------------------------------------------
            }
        }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError volleyError) {
                //-------------------------------------------------------
                Toast.makeText(getActivity(), "Volley error: " + volleyError.toString(), Toast.LENGTH_LONG).show();
                //-------------------------------------------------------
            }
        });
        // RequestQueue
        RequestQueue requestQueue = Volley.newRequestQueue(getActivity());
        requestQueue.add(jsonObjectRequest);

    }  // newMethod end here  =================





    private void statusUpdate(String ID, String STATUS) {
        progressbar.setVisibility(View.VISIBLE);

        String url = "https://khulnagtech.fun/client_project/RoktoBondhon/status_update.php";

        StringRequest stringRequest = new StringRequest(Request.Method.POST, url,
                response -> {
                    progressbar.setVisibility(View.GONE);
                    Log.d(TAG, "Status Update Response: " + response);
                    Toast.makeText(getActivity(), "Status updated: " + response, Toast.LENGTH_SHORT).show();
                },
                error -> {
                    progressbar.setVisibility(View.GONE);
                    Log.e(TAG, "Status Update Error: " + error.toString());
                    Toast.makeText(getActivity(), "Status update error: " + error.toString(), Toast.LENGTH_LONG).show();
                }) {
            @Nullable
            @Override
            protected Map<String, String> getParams() throws AuthFailureError {
                Map<String, String> myMap = new HashMap<>();
                myMap.put("id", ID);

                if (STATUS.equalsIgnoreCase("Pending")) {
                    myMap.put("status", "Available");
                } else if (STATUS.equalsIgnoreCase("Available")) {
                    myMap.put("status", "Not_Available");
                } else if (STATUS.equalsIgnoreCase("Not_Available")) {
                    myMap.put("status", "Available");
                } else {
                    myMap.put("status", "Pending");
                }

                Log.d(TAG, "Sending status update: " + myMap.toString());
                return myMap;
            }
        };

        Volley.newRequestQueue(getActivity()).add(stringRequest);
    }  //  statusUpdate  end here





    // Refresh
    @Override
    public void onResume() {
        super.onResume();
        if (!isLoaded) {
            try {
                GetDataLoad();  //  Method ke Call kora  ===========
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            isLoaded = true;
        }
    }


    //========================================================================================================================
}  //  Fragment end here
//============================================================================================================================
